% EE-472 Smart Grids Technologies 2025
% Lab - Nodal Admittance Matrix Calculus

clear;
close all;

disp(' ');
disp('*************************************************');
disp('* This script computes the Y matrix *');
disp('*************************************************');
disp(' ');

%%  Step 1: line parameters

% Load the line parameters from a text file.
% The lines of the text file need to have the following format:
% Bus Bus R(Ohm/km) X(Ohm/km) B(Siemens/km) length(km) V_base(V).

disp('STEP 1a: Load line parameters');
disp(' ');

linedata = load('data_lines.txt');

idx_from    = linedata(:,1);
idx_to      = linedata(:,2);
R_prime     = linedata(:,3);
X_prime     = linedata(:,4);
B_prime     = linedata(:,5);
l           = linedata(:,6);
V_b         = linedata(:,7);

disp('STEP 1b: Load transformer parameters');
disp(' ');

transformer_data = load('data_transformers.txt');

if(~isempty(transformer_data))
    idx_1 = transformer_data(:,1);
    idx_2 = transformer_data(:,2);
    A_n   = transformer_data(:,3);
    V_n1  = transformer_data(:,4);
    V_n2  = transformer_data(:,5);
    r_sc  = transformer_data(:,6);
    x_sc  = transformer_data(:,7);
    V_b1  = transformer_data(:,8);
    V_b2  = transformer_data(:,9);
else
    idx_1 = [];
    idx_2 = [];
    A_n = [];
    V_n1  = [];
    V_n2  = [];
    r_sc  = [];
    x_sc  = [];
    V_b1  = [];
    V_b2  = [];
end

%warning('This needs to be updated.');
n_lines = length(idx_from); % number of lines
n_transfo = length(idx_1);	% number of transformers
n_nodes = max([idx_from;idx_to;idx_1;idx_2]);   % number of nodes

disp(['The network consists of ' int2str(n_nodes) ' nodes, ' ...
    int2str(n_lines), ' lines, and ' int2str(n_transfo), ' transformers.']);
disp(' ');

%%  Step 2: base values & pi-equivalent circuits

% Define the base power and base voltage here.
% The base current and base admittance are computed automatically.

disp('STEP 2: Transform line parameters to p.u.');
disp(' ');

% !!! put the correct base value here !!!
A_b = 6e6;      % base value for the power in VA

% Construct the pi-section equivalent circuits, i.e. structs with fields
% i         start node
% j         end node
% Y_ij      branch admittance
% Y_i_ij    shunt admittance on start-node side
% Y_j_ij    shunt admittacne on end-node side

pi_lines        = build_lines(idx_from, idx_to, R_prime, X_prime, B_prime, l, V_b, A_b);
pi_transformers = build_transformers(idx_1, idx_2, A_n, V_n1, V_n2, r_sc, x_sc, V_b1, V_b2, A_b);
pi_circuits     = [pi_lines, pi_transformers].';

%%  Step 3: build primitive admittance matrices and incidence matrix

disp('STEP 3: Build primitive admittance matrices and incidence matrix');
disp(' ');

[A,Y_L,Y_T] = calculate_parameters(pi_circuits);

%%  Step 4: compute the nodal admittance matrix

disp('STEP 4: Compute the nodal admittance matrix')
disp(' ')

Y = A.' * Y_L * A + Y_T;

disp('Admittance Matrices');
disp(' ');

print_matrix(Y_L,'Y_L','%4.3e');
disp(' ');

print_matrix(Y_T,'Y_T','%4.3e');
disp(' ');

print_matrix(Y,'Y','%4.3e');
disp(' ');